<?php ob_start();
require "config/database.php";
require "config/function.php";
require "config/functions.crud.php";
include "assets/back/vendors/phpqrcode/qrlib.php";
session_start();
if (!isset($_SESSION['id_siswaskl'])) {
    die('Anda tidak diijinkan mengakses langsung');
}
$siswa = fetch($koneksi, 'siswa', ['id' => dekripsi($_GET['id'])]);
$skl = fetch($koneksi, 'skl', ['id_skl' => 1]);
$tempdir = "temp/"; //Nama folder tempat menyimpan file qrcode
if (!file_exists($tempdir)) //Buat folder bername temp
    mkdir($tempdir);

//isi qrcode jika di scan
$codeContents = $siswa['nis'] . '-' . $siswa['nama'];

//simpan file kedalam temp
//nilai konfigurasi Frame di bawah 4 tidak direkomendasikan

QRcode::png($codeContents, $tempdir . $siswa['nis'] . '.png', QR_ECLEVEL_M, 4);

?>
<!DOCTYPE html>
<html>

<head>
    <meta charset='utf-8'>

    <title>SKL_<?= $siswa['nama'] ?></title>

    <!-- General CSS Files -->
    <link rel="stylesheet" href="assets/back/vendors/bootstrap/dist/css/bootstrap.min.css">

    <style>
        @page {
            margin-top: 0 px !important;
            margin-bottom: 0 px !important;
        }
    </style>
</head>

<body style="font-size: 12px;">
    <?php if ($skl['header'] == '') { ?>
        <h3><?= $setting['nama_sekolah'] ?></h3>
        <p><small> <?= $setting['alamat'] ?></small></p>
    <?php } else { ?>
        <img src="<?= $skl['header'] ?>" width="100%">
    <?php } ?>
    <hr>
    <center>
        <h5><u><?= $skl['nama_surat'] ?></u></h5>
        <!-- No. Surat : <?= sprintf("%03d", $siswa['id']); ?><?= $skl['no_surat'] ?><?= date('Y') ?> -->
        No. Surat : <?= $skl['no_surat'] ?>
    </center>
    <br><br>
    <div class="col-md-12">
        <?= $skl['pembuka'] ?>
        <table style="margin-left: 80px;margin-right:80px" class="table table-sm table-bordered">
            <tr>
                <td>Nama</td>
                <td><b><?= $siswa['nama'] ?></b></td>
            </tr>
            <tr>
                <td>Tempat, Tgl Lahir</td>
                <td><?= $siswa['tempat'] ?>, <?= $siswa['tgl_lahir'] ?></td>
            </tr>
            <tr>
                <td>NIS / NISN</td>
                <td><?= $siswa['nis'] ?> / <?= $siswa['nisn'] ?> </td>
            </tr>
            <?php if ($siswa['jurusan'] <> null or $siswa['jurusan'] <> "") { ?>
                <tr>
                    <td>Kelas</td>
                    <td><?= $siswa['jurusan'] ?></td>
                </tr>
            <?php } ?>
        </table>
        <p><?= $skl['isi_surat'] ?> </p>

        <center>
            <?php if ($siswa['keterangan'] == 1) { ?>
                <h5>LULUS</h5>
            <?php } elseif ($siswa['keterangan'] == 2) { ?>
                <h5>LULUS BERSYARAT</h5>
            <?php } else { ?>
                <h5>TIDAK LULUS</h5>
            <?php } ?>
        </center>

        <?php if ($skl['nilaisiswa'] == 1) { ?>
            <table style="margin-left: 30px;margin-right:30px;font-size:10px" class="table table-sm table-bordered">
                <thead style="background-color:cornflowerblue;">
                    <tr>
                        <th style="margin-left: auto; margin-right: auto; text-align: center;">No</th>
                        <th style="margin-left: auto; margin-right: auto; text-align: center;">Mata Pelajaran</th>
                        <th style="margin-left: auto; margin-right: auto; text-align: center;">Nilai</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($skl['kelompok'] == 1) { ?>
                        <?php
                        $q1 = mysqli_query($koneksi, "SELECT * FROM mapel group by kelompok order by kelompok");
                        $total = 0;
                        $no = 0;
                        while ($kelompok = mysqli_fetch_array($q1)) {

                            $query = mysqli_query($koneksi, "SELECT * FROM mapel where kelompok='$kelompok[kelompok]' and (jurusan='$siswa[jurusan]' or jurusan='semua') order by no_urut ");

                        ?>
                            <tr>
                                <td colspan="3"><b>Kelompok <?= $kelompok['kelompok'] ?></b></td>
                            </tr>
                            <?php
                            while ($mapel = mysqli_fetch_array($query)) {

                                $nilai = fetch($koneksi, 'nilai', ['kode_mapel' => $mapel['kode_mapel'], 'nis' => $siswa['nis']]);
                                $total = $total + floatval($nilai['nilai']);
                                $no++;
                            ?>
                                <tr>
                                    <td style="margin-left: auto; margin-right: auto; text-align: center; width: 20px;"><?= $no ?></td>
                                    <td><?= $mapel['nama_mapel'] ?></td>
                                    <td style="margin-left: auto; margin-right: auto; text-align: center; width: 50px;"><?= $nilai['nilai'] ?></td>
                                </tr>
                        <?php }
                        } ?>
                        <tr style="background-color:lightsteelblue;">
                            <td colspan="2"><b>NILAI RATA RATA </b></td>
                            <td style="margin-left: auto; margin-right: auto; text-align: center;""><b> <?= round($total / $no, 2)  ?></b></td>

                        </tr>
                    <?php } else { ?>

                        <?php
                        $query = mysqli_query($koneksi, "SELECT * FROM mapel where (jurusan='$siswa[jurusan]' or jurusan='semua') order by no_urut ");
                        $no = 0;
                        $total = 0;
                        while ($mapel = mysqli_fetch_array($query)) {
                            $nilai = fetch($koneksi, 'nilai', ['kode_mapel' => $mapel['kode_mapel'], 'nis' => $siswa['nis']]);
                            $no++;
                            $total = $total + floatval($nilai['nilai']);

                        ?>
                            <tr>
                                <td style="width: 20px;"><?= $no ?></td>
                                <td><?= $mapel['nama_mapel'] ?></td>
                                <td style="margin-left: auto; margin-right: auto; text-align: center; width: 50px;"><?= $nilai['nilai'] ?></td>
                            </tr>
                        <?php }
                        ?>
                        <tr style="background-color:lightsteelblue;">
                            <td colspan="2"><b>NILAI RATA RATA </b></td>
                            <td style="margin-left: auto; margin-right: auto; text-align: center;><b> <?= round($total / $no, 2)  ?></b></td>

                        </tr>
                    <?php } ?>
                </tbody>
            </table>

        <?php } ?>
        <?= $skl['penutup'] ?>
        <br><br>
        <table width="100%">
										<tr>
											<td style="text-align: center">
												<font size="13px">
													<img class="img" src="temp/<?= $siswa['nisn'] ?>.png" ec="H" style="width: 30mm; background-color: white; color: black;">
												</font>
											</td>
											
											<td style="text-align: center">
												<font size="13px">
													<img class="img" src="admin/upload/<?= $siswa['nisn'] ?>.jpg" ec="H" style="width: 30mm;hight: 40mm; background-color: white; color: black;">
												</font>
											</td>
											<td style="text-align: left"></td><td></td><td></td>
											<td style="text-align: left"></td>
											
											
											<td style="text-align: left">
												<?= $setting['kota'] ?>, <?= $skl['tgl_surat'] ?>
												<p>Kepala <?= $setting['nama_sekolah'] ?></p>
												<br></br><br>
												<?= $setting['nama_kepsek'] ?>
												<p><?= $setting['nip_kepsek'] ?></p>
												<?php if ($skl['sttd'] == 1) { ?>
													<img style="z-index: 800;position:absolute;margin-top:-140px;margin-left:-40px" class="img" src="<?= $skl['ttd'] ?>" width="<?= $skl['wttd'] ?>">
												<?php } ?>
												<?php if ($skl['sstempel'] == 1) { ?>
													<img style="z-index: 900;position:absolute;margin-top:-130px;margin-left:-70px;opacity:0.7" class="img" src="<?= $skl['stempel'] ?>" width="<?= $skl['wstempel'] ?>">
												<?php } ?>
											</td>
										</tr>
									</table>
																				<!-- batas======================================-->
</body>

</html>
<?php

$html = ob_get_clean();
require_once 'vendor/autoload.php';

use Dompdf\Dompdf;

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('legal', 'portrait');
$dompdf->render();
$dompdf->stream("SKL_" . $siswa['nama'] . ".pdf", array("Attachment" => false));
exit(0);
?>